---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：100-MCP（Model Context Protocol）サーバー

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があるため、特になし

## 2) 参照した情報（Evidence一覧）

- E-01: `packages/next/src/server/mcp/get-mcp-middleware.ts` - getMcpMiddleware関数
- E-02: `packages/next/src/server/mcp/get-or-create-mcp-server.ts` - getOrCreateMcpServer関数、McpServerOptions型
- E-03: `packages/next/src/server/mcp/mcp-telemetry-tracker.ts` - McpTelemetryTracker、recordMcpTelemetry
- E-04: `packages/next/src/server/mcp/tools/get-errors.ts` - registerGetErrorsTool
- E-05: `packages/next/src/server/mcp/tools/get-routes.ts` - registerGetRoutesTool
- E-06: `packages/next/src/server/mcp/tools/get-project-metadata.ts` - registerGetProjectMetadataTool
- E-07: `docs/code-to-docs/機能一覧/機能一覧.csv` - No.100の説明

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | /_next/mcpパスでリクエストを受け付ける | E-01 (16行目) | ○ |
| C-02 | シングルトンパターンでMCPサーバーを管理 | E-02 (22-27行目) | ○ |
| C-03 | 6つのツールが登録される | E-02 (34-56行目) | ○ |
| C-04 | StreamableHTTPServerTransportを使用 | E-01 (7行目 import, 20行目) | ○ |
| C-05 | リクエストボディ1MB制限 | E-01 (28行目) | ○ |
| C-06 | sessionIdGeneratorがundefined（ステートレス） | E-01 (21行目) | ○ |
| C-07 | MCPサーバー名は"Next.js MCP Server" | E-02 (30行目) | ○ |
| C-08 | バージョンは0.2.0 | E-02 (31行目) | ○ |
| C-09 | get_errorsはブラウザ接続なしでエラーを返す | E-04 (48-61行目) | ○ |
| C-10 | get_errorsはHMR経由でブラウザと通信 | E-04 (63-68行目) | ○ |
| C-11 | テレメトリ追跡（recordToolCall） | E-03 (19-22行目), E-04 (45行目), E-05 (54行目), E-06 (18行目) | ○ |
| C-12 | get_routesはrouterTypeでフィルタ可能 | E-05 (49行目, 57-60行目) | ○ |
| C-13 | get_routesはファイルシステムスキャン | E-05 (93行目 collectAppFiles, 137行目 collectPagesFiles) | ○ |
| C-14 | McpServerOptionsに8つのプロパティ | E-02 (11-20行目) | ○ |
| C-15 | エラー時500レスポンスをJSON-RPCで返す | E-01 (31-41行目) | ○ |
| C-16 | res.onでclose時にtransport.close() | E-01 (24-26行目) | ○ |
| C-17 | recordMcpTelemetryでテレメトリシステムに統合 | E-03 (69-83行目) | ○ |
| C-18 | mcpTelemetryTrackerはシングルトン | E-03 (50行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし。全主張に根拠あり。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全てのソースファイルを読み取り済み
- 0: 低リスク - MCPプロトコルの詳細は外部SDKに依存するが、Next.js側の実装は完全に確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 6つのツールの入出力仕様が正確か
- [ ] HMR経由のブラウザ通信のタイムアウト値が適切か
- [ ] テレメトリイベントの形式がテレメトリシステムと整合しているか
- [ ] MCPプロトコルバージョンの互換性が確認されているか
